<?php


namespace App\Controllers\Admin;


use App\Helpers\Validacao;
use App\Models\Galeria;
use App\Models\Session;

class GaleriaController
{
    public function galerias()
    {
        $galerias = Galeria::withCount(['fotos'])->get();
        return $galerias;
    }

    public function store($data)
    {
        $galeria = Galeria::create($data);
        return $galeria->id;
    }

    public function edit($id)
    {
        return Galeria::find($id);
    }

    public function update($data)
    {
        $galeria = Galeria::find($data['galeria_id']);
        $galeria->update($data);
    }

    public function destroy($data)
    {
       $galeria = Galeria::find($data['galeria_id']);
       foreach ($galeria->fotos as $foto){
           $this->removerImagem($foto->url);
           $foto->delete();
       }
        $galeria->delete();
    }

    private function removerImagem($imagem)
    {
        if (file_exists('../uploads/galeria/' . $imagem)) {
            @unlink('../uploads/galeria/' . $imagem);
        }
    }
}