<?php


namespace App\Controllers\Admin;


use App\Models\NoticiaFoto;

class NoticiaFotoController
{
    public function destroy($data)
    {
        foreach ($data['fotos'] as $photo_id) {
            $photo = NoticiaFoto::find($photo_id);
            $this->removerImagem($photo->url);
            $photo->delete();
        }
    }

    private function removerImagem($imagem)
    {
        if (file_exists('../uploads/noticia/' . $imagem)) {
            @unlink('../uploads/noticia/' . $imagem);
        }
    }

    public function posicao($data)
    {
        foreach ($data['item'] as $pos => $id) {
            $foto_id = preg_replace('/li_/', ' ', $id);
            NoticiaFoto::find($foto_id)->update(['pos' => $pos]);
        }
    }

    public function upload()
    {
        if ($_SERVER['REQUEST_METHOD'] == "POST") {
            $ext = strtolower(substr($_FILES['file']['name'], -4));
            $url = uniqid(time(), true) . $ext;
            if (move_uploaded_file($_FILES['file']['tmp_name'], "../uploads/noticia/" . $url)) {
                $noticia_id = $_REQUEST['noticia_id'];
                $foto = NoticiaFoto::create([
                    'url' => $url,
                    'noticia_id' => $noticia_id,
                ]);
                echo json_encode(array('url' => $foto->url, 'id' => $foto->id));
            }
        }
    }
}