<?php


namespace App\Controllers\Admin;



use App\Models\Venda2Foto;

class Venda2FotoController
{
    public function destroy($data)
    {
        foreach ($data['fotos'] as $photo_id) {
            $photo = Venda2Foto::find($photo_id);
            $this->removerImagem($photo->file_name);
            $photo->delete();
        }
    }

    private function removerImagem($imagem)
    {
        if (file_exists('../uploads/vendas/' . $imagem)) {
            @unlink('../uploads/vendas/' . $imagem);
        }
    }

    public function posicao($data)
    {
        foreach ($data['item'] as $pos => $id) {
            $foto_id = preg_replace('/li_/', ' ', $id);
            Venda2Foto::find($foto_id)->update(['pos' => $pos]);
        }
    }

    public function upload()
    {
        if ($_SERVER['REQUEST_METHOD'] == "POST") {
            $ext = strtolower(substr($_FILES['file']['name'], -4));
            $url = uniqid(time(), true) . $ext;
            if (move_uploaded_file($_FILES['file']['tmp_name'], "../uploads/vendas/" . $url)) {
                $venda_id = $_REQUEST['id'];
                $foto = Venda2Foto::create([
                    'file_name' => $url,
                    'venda2_id' => $venda_id,
                ]);
                echo json_encode(['file_name' => $foto->file_name, 'id' => $foto->id]);
            }
        }
    }
}