<?php


namespace App\Controllers\Site;


use App\Models\Venda;
use App\Models\VendaFoto;

class VendaController
{
    public function vendas()
    {
        return Venda::addSelect([
            'foto' => VendaFoto::select('url')->whereColumn('venda_id', 'vendas.id')->orderBy('pos', 'ASC')->limit(1)
        ])->get();
    }

    public function venda($id)
    {
        $venda = Venda::with('fotos')->find($id);
        return $venda;
    }
}