<?php

namespace Models;

require_once __DIR__ . '/../../config/database.php';

use Illuminate\Database\Eloquent\Model as Eloquent;

/**
 * @author Marcelo Rocha <catracacelo@gmail.com> <marcelo@planetascript.com>
 * <website www.planetascript.com>
 */
class Foton extends Eloquent {

    protected $primaryKey = 'foton_id';
    protected $table = 'foton';
    public $timestamps = false;
    protected $fillable = [
        'foton_url', 'foton_pos', 'foton_noticia'
    ];

    public function FotoByNoticia($id) {
        return Foton::where('foton_noticia', '=', $id)->orderBy('foton_pos', 'ASC')->get();
    }


    public function count($id) {
        return Foton::where('foton_noticia', '=', $id)->count();
    }

}
