<?php

namespace Models;

require_once __DIR__ . '/../../config/database.php';

use Illuminate\Database\Eloquent\Model as Eloquent;

/**
 * @author Marcelo Rocha <catracacelo@gmail.com> <marcelo@planetascript.com>
 * <website www.planetascript.com>
 */
class Fotove extends Eloquent {

    public $timestamps = false;
    protected $fillable = [
        'url', 'pos', 'vendas_id'
    ];

    public function FotoByVendas($id) {
        return Fotove::where('vendas_id', '=', $id)->orderBy('pos', 'ASC')->get();
    }


    public function count($id) {
        return Fotove::where('vendas_id', '=', $id)->count();
    }

}
