<?php

namespace Models;

require_once __DIR__ . '/../../config/database.php';

use Illuminate\Database\Eloquent\Model as Eloquent;

/**
 * @author Marcelo Rocha <catracacelo@gmail.com> <marcelo@planetascript.com>
 * <website www.planetascript.com>
 * Classe Noticia
 */
class Vendas2 extends Eloquent
{
    protected $table = 'vendas2';
    public $timestamps = false;
    protected $fillable = [
        'titulo', 'descricao',
    ];

    public function fotos()
    {
        return $this->hasMany(FotoVendas::class)->orderBy('pos', 'ASC');
    }

    public function edit($id)
    {
        return Vendas2::find($id);
    }

    public function show()
    {
        return Vendas2::orderBy('id', 'DESC')->get();
    }

    public function limit()
    {
        return Vendas2::orderBy('id', 'DESC')->take(3)->get();
    }

    public function paginate()
    {
        return Vendas2::orderBy('id', 'DESC')->paginate(12);
    }

}
