<?php

namespace Models;

require_once __DIR__ . '/../../config/database.php';

use Illuminate\Database\Eloquent\Model as Eloquent;

/**
 * @author Marcelo Rocha <catracacelo@gmail.com> <marcelo@planetascript.com>
 * <website www.planetascript.com>
 *
 * Classe video
 *
 *
 */
class CategoriaGaleria extends Eloquent
{


    public $timestamps = false;
    protected $fillable = [
        'nome'
    ];

    public function show()
    {
        return CategoriaGaleria::orderBy('id', 'DESC')->get();
    }

    public function galerias()
    {
        return $this->hasMany(Galeria::class);
    }

    public function paginate()
    {
        return CategoriaGaleria::orderBy('id', 'DESC')->paginate(24);
    }

}
