<?php

namespace Models;

require_once __DIR__ . '/../../config/database.php';

use Illuminate\Database\Eloquent\Model as Eloquent;

/**
 * @author Marcelo Rocha <catracacelo@gmail.com> <marcelo@planetascript.com>
 * <website www.planetascript.com>
 * Classe Noticia
 */
class Galeria extends Eloquent
{

    public $timestamps = false;
    protected $fillable = [
        'nome', 'status','categoria_galeria_id'
    ];

    public function edit($id)
    {
        return Galeria::find($id);
    }

    public function show()
    {
        return Galeria::orderBy('id', 'DESC')->get();
    }

    public function status()
    {
        return Galeria::where('status', '=', 1)->take(4)->get();
    }

    public function galeria($id)
    {
        return Galeria::join('foto', 'galeria_id', '=', 'id')->where('id', '=', $id)->get();
    }

    public function paginate($id)
    {
        return Galeria::where('categoria_galeria_id', $id)->paginate(12);
    }

    public function fotos()
    {
        return $this->hasMany(Foto::class)->orderBy('pos','ASC');
    }

    public function categoria()
    {
        return $this->belongsTo(CategoriaGaleria::class, 'categoria_galeria_id',  'id');
    }

}
