<?php

namespace Models;

require_once __DIR__ . '/../../config/database.php';

use Illuminate\Database\Eloquent\Model as Eloquent;

/**
 * @author Marcelo Rocha <catracacelo@gmail.com> <marcelo@planetascript.com>
 * <website www.planetascript.com>
 * 
 * Classe video
 * 
 * 
 */
class Video extends Eloquent {

    protected $primaryKey = 'video_id';
    protected $table = 'video';
    public $timestamps = false;
    protected $fillable = [
        'video_url', 'video_thumb',
    ];

    public function show() {
        return Video::orderBy('video_id', 'DESC')->get();
    }
    
    public function limit() {
        return Video::orderBy('video_id', 'DESC')->take(4)->get();
    }
    public function paginate() {
        return Video::orderBy('video_id', 'DESC')->paginate(12);
    }

}
