<?php
require_once __DIR__ . '/../vendor/autoload.php';
$sid = new \Model\Session();
$sid->start();
if (!$sid->check()) {
    header('location:' . \Validacao::getBaseAdmin() . 'login.php');
    exit;
}
$artigo = (new \Models\Artigo)->show();
?>
<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <title>ADMIN | Galeria de Fotos</title>
        <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
        <link href="bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
        <link href="plugins/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
        <link href="plugins/ionicons/css/ionicons.min.css" rel="stylesheet" type="text/css" />
        <link href="plugins/input-text/style.min.css" rel="stylesheet" type="text/css" />
        <link href="plugins/datatables/dataTables.bootstrap.css" rel="stylesheet" type="text/css" />
        <link href="plugins/bootstrap-fileinput/css/fileinput.min.css" rel="stylesheet" type="text/css" />
        <link href="plugins/sweetalert/dist/sweetalert.css" rel="stylesheet" type="text/css" />
        <link href="dist/css/AdminLTE.min.css" rel="stylesheet" type="text/css" />
        <link href="dist/css/skins/_all-skins.min.css" rel="stylesheet" type="text/css" />
        <link href="dist/css/skins/ui.css" rel="stylesheet" type="text/css" />
        <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
            <script src="plugins/jQuery/html5shiv.min.js"></script>
            <script src="plugins/jQuery/respond.min.js"></script>
        <![endif]-->
    </head>
    <body class="skin-blue sidebar-mini">
        <div class="wrapper">
            <header class="main-header">
                <?php require_once './topo.php'; ?>
            </header>
            <aside class="main-sidebar">
                <?php require_once './menu.php'; ?>
            </aside>
            <div class="content-wrapper">
                <section class="content-header">
                    <h1> Artigo</h1>
                    <ol class="breadcrumb">
                        <li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
                        <li class="active">Artigo</li>
                    </ol>
                </section>
                <section class="content">
                    <div class="row">
                        <div class="col-xs-12">
                            <div class="box box-primary">
                                <div class="box-header">
                                    <a href="artigo_novo.php">
                                        <button class="btn btn-sm btn-primary">
                                            <i class="fa fa-plus"></i>
                                            Adicionar novo
                                        </button>
                                    </a>
                                </div>
                                <div class="box-body">
                                    <table class="table table-bordered table-hover">
                                        <thead>
                                            <tr>
                                                <th width="65">Imagem</th>
                                                <th>Título</th>
                                                <th>Descriçao</th>
                                                <th width="85">Ações</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php if (isset($artigo[0])): ?>
                                                <?php foreach ($artigo as $a): ?>
                                                    <tr>
                                                        <td>
                                                            <img src="../uploads/<?= $a->artigo_imagem ?>" class="img-responsive img-circle" style="width: 45px;height: 45px">
                                                        </td>
                                                        <td><?= stripslashes($a->artigo_nome) ?></td>
                                                        <td><?= Validacao::cut($a->artigo_descricao, 120, '...') ?></td>
                                                        <td>
                                                            <a class="btn btn-sm btn-default" href="artigo_editar.php?id=<?= $a->artigo_id ?>">
                                                                <i class="fa fa-edit"></i>
                                                            </a> 
                                                            <a class="btn btn-sm btn-danger excluir" data-url="artigo_fn.php?acao=remover&AMP;artigo_id=<?= $a->artigo_id ?>" >
                                                                <i class="fa fa-trash"></i>
                                                            </a>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
            <?php require_once './rodape.php'; ?>
            <div class='control-sidebar-bg'></div>
        </div>
        <script src="plugins/jQuery/jQuery-2.1.4.min.js"></script>
        <script src="bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
        <script src='plugins/sweetalert/dist/sweetalert.min.js'></script>
        <script src='plugins/bootstrap-fileinput/js/fileinput.min.js'></script>
        <script src="plugins/datatables/jquery.dataTables.min.js" type="text/javascript"></script>
        <script src="plugins/datatables/dataTables.bootstrap.min.js" type="text/javascript"></script>
        <script src="plugins/slimScroll/jquery.slimscroll.min.js" type="text/javascript"></script>
        <script src='plugins/fastclick/fastclick.min.js'></script>
        <script src='plugins/sweetalert/sweetalert.js'></script>
        <script src="dist/js/app.min.js" type="text/javascript"></script>
        <script src="dist/js/demo.js" type="text/javascript"></script>
        <script type="text/javascript">
            $(".artigos").addClass('active');
<?php if (isset($_GET['atualizado'])): ?>
                _alertsuccess("Sucesso!", "Notícia cadastrada :)");
<?php endif; ?>
<?php if (isset($_GET['removido'])): ?>
                _alertsuccess("Deletado!", "Notícia foi removida :(");
<?php endif; ?>
            $(function () {
                $("table").dataTable();
            });
        </script>
    </body>
</html>
