<?php

use Models\CategoriaGaleria;

require_once __DIR__ . '/../vendor/autoload.php';
$sid = new \Model\Session();
$sid->start();
if (!$sid->check()) {
    header('location:' . Validacao::getBaseAdmin() . 'login.php');
    exit;
}

function incluir()
{
    $data = filter_input_array(INPUT_POST, FILTER_DEFAULT);
    CategoriaGaleria::create($data);
    Filter::redirect("categoria-galeria.php");
}

function atualizar()
{
    $data = filter_input_array(INPUT_POST, FILTER_DEFAULT);
    CategoriaGaleria::find($data['id'])->update($data);
    Filter::redirect("categoria-galeria.php?atualizado");
}

function remover()
{
    $data = filter_input_array(INPUT_GET, FILTER_DEFAULT);
    $remover = CategoriaGaleria::find($data['id']);
    foreach ($remover->galerias as $galeria) {
        foreach ($galeria->fotos as $foto) {
            if (file_exists('../uploads/galeria/' . $foto->url)) {
                @unlink('../uploads/galeria/' . $foto->url);
            }
        }
        $galeria->delete();
    }
    $remover->delete();
    Filter::redirect("categoria-galeria.php?removido");
}

function Json()
{
    $data = filter_input_array(INPUT_GET, FILTER_DEFAULT);
    $json = CategoriaGaleria::find($data['id']);
    echo $json;
}

if (isset($_REQUEST['acao']) && !empty($_REQUEST['acao'])) {
    $acao = $_REQUEST['acao'];
    if (function_exists($acao)) {
        $acao();
    }
}

