<?php

use Models\Galeria;

require_once __DIR__ . '/../vendor/autoload.php';
$sid = new \Model\Session();
$sid->start();
if (!$sid->check()) {
    header('location:' . \Validacao::getBaseAdmin() . 'login.php');
    exit;
}

function incluir() {
    $data = filter_input_array(INPUT_POST, FILTER_DEFAULT);
    $id = Galeria::insertGetId($data);
    Filter::redirect("galeria_editar.php?id=$id");
}

function atualizar() {
    $data = filter_input_array(INPUT_POST, FILTER_DEFAULT);
    Galeria::where('id', '=', $data['id'])->update($data);
    Filter::redirect("galeria.php?atualizado");
}

function remover() {
    $data = filter_input_array(INPUT_GET, FILTER_DEFAULT);
    $remover = Galeria::find($data['id']);
    foreach ($remover->fotos as $item) {
        if (file_exists('../uploads/galeria/' . $item->url)) {
            @unlink('../uploads/galeria/' . $item->url);
        }
        $item->delete();
    }
    $remover->delete();
    Filter::redirect("galeria.php?removido");
}

if (isset($_REQUEST['acao']) && !empty($_REQUEST['acao'])) {
    $acao = $_REQUEST['acao'];
    if (function_exists($acao)) {
        $acao();
    }
}

