<?php

require_once __DIR__ . '/../vendor/autoload.php';
$sid = new \Model\Session();
$sid->start();
if (!$sid->check()) {
    header('location:' . \Validacao::getBaseAdmin() . 'login.php');
    exit;
}

function incluir() {
    $data = filter_input_array(INPUT_POST, FILTER_DEFAULT);
    $arquivo = explode('.', $_FILES["pdf_arquivo"]['name']);
    $nome_final = str_slug($arquivo[0]) . time() . '.pdf';
    move_uploaded_file($_FILES["pdf_arquivo"]['tmp_name'], "../uploads/pdf/$nome_final");
    $pdf = ['pdf_arquivo' => $nome_final];
    $array = array_merge($data, $pdf);
    \Models\Pdf::insert($array);
    Filter::redirect("pdf.php?cadastrado");
}

function atualizar() {
    $data = filter_input_array(INPUT_POST, FILTER_DEFAULT);
    $atualizar = \Models\Pdf::find($data['pdf_id']);
    if ($_FILES["pdf_arquivo"]['name'] != '') {
        if (file_exists('../uploads/pdf/' . $atualizar->pdf_arquivo)) {
            @unlink('../uploads/pdf/' . $atualizar->pdf_arquivo);
        }
        $arquivo = explode('.', $_FILES["pdf_arquivo"]['name']);
        $nome_final = str_slug($arquivo[0]) . time() . '.pdf';
        move_uploaded_file($_FILES["pdf_arquivo"]['tmp_name'], "../uploads/pdf/$nome_final");
        $data = ['pdf_arquivo' => $nome_final] + $data;
    } else {
        unset($data["pdf_arquivo"]);
    }
    $atualizar->update($data);
    Filter::redirect("pdf.php?atualizado");
}

function remover() {
    $data = filter_input_array(INPUT_GET, FILTER_DEFAULT);
    $remover = \Models\Pdf::find($data['pdf_id']);
    if (file_exists('../uploads/pdf/' . $remover->pdf_arquivo)) {
        @unlink('../uploads/pdf/' . $remover->pdf_arquivo);
    }
    $remover->delete();
    Filter::redirect("pdf.php?removido");
}

function Json() {
    $data = filter_input_array(INPUT_GET, FILTER_DEFAULT);
    $json = \Models\Pdf::find($data['pdf_id']);
    echo $json;
}

if (isset($_REQUEST['acao']) && !empty($_REQUEST['acao'])) {
    $acao = $_REQUEST['acao'];
    if (function_exists($acao)) {
        $acao();
    }
}

