<?php
session_start();
require_once '../loader.php';
if ($_SESSION['LOGADO'] == FALSE) {
    @header('location:' . Validacao::getBaseAdmin() . 'login.php');
    exit;
}
$s = new Seo;
$seo = $s->getMeta();

$bps = new Post;
$posts = $bps->getPots();
?>
<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <title><?= $seo->seo_meta_title ?></title>
        <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
        <!-- Bootstrap 3.3.4 -->
        <link href="bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
        <!-- Font Awesome Icons -->
        <link href="plugins/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
        <!-- Ionicons -->
        <link href="plugins/ionicons/css/ionicons.min.css" rel="stylesheet" type="text/css" />
        <!-- DATA TABLES -->
        <link href="plugins/input-text/style.min.css" rel="stylesheet" type="text/css" />
        <link href="plugins/datatables/dataTables.bootstrap.css" rel="stylesheet" type="text/css" />
        <link href="plugins/bootstrap-fileinput/css/fileinput.min.css" rel="stylesheet" type="text/css" />
        <link href="plugins/sweetalert/dist/sweetalert.css" rel="stylesheet" type="text/css" />
        <!-- Theme style -->
        <link href="dist/css/AdminLTE.min.css" rel="stylesheet" type="text/css" />
        <link href="dist/css/skins/_all-skins.min.css" rel="stylesheet" type="text/css" />
        <link href="dist/css/skins/ui.css" rel="stylesheet" type="text/css" />
        <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
            <script src="plugins/jQuery/html5shiv.min.js"></script>
            <script src="plugins/jQuery/respond.min.js"></script>
        <![endif]-->
    </head>
    <body class="skin-blue sidebar-mini">
        <div class="wrapper">

            <header class="main-header">
                <?php require_once './topo.php'; ?>
            </header>
            <aside class="main-sidebar">
                <?php require_once './menu.php'; ?>
            </aside>
            <div class="content-wrapper">
                <section class="content-header">
                    <h1> Gerênciar  Post(s)</h1>
                    <ol class="breadcrumb">
                        <li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
                        <li class="active"> Post(s)</li>
                    </ol>
                </section>

                <section class="content">
                    <div class="row">
                        <div class="col-xs-12">
                            <div class="box box-primary">
                                <div class="box-header">
                                    <a href="post_novo.php">
                                        <button class="btn btn-sm btn-primary">
                                            <i class="fa fa-plus"></i>
                                            Adicionar novo
                                        </button>
                                    </a>
                                    <p></p>
                                    <h3 class="box-title">Post(s) Cadastrado(s)</h3>
                                </div>
                                <div class="box-body">
                                    <table class="table table-bordered table-hover">
                                        <thead>
                                            <tr>
                                                <th>Imagem</th>
                                                <th>Título</th>
                                                <th>Data</th>
                                                <th>Descrição</th>
                                                <th width="85">Ações</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php if (isset($posts[0])): ?>
                                                <?php foreach ($posts as $p): ?>
                                                    <tr>
                                                        <td>
                                                            <img src="thumb.php?w=50&h=50&zc=0&src=../uploads/<?php echo $p->post_imagem != '' ? $p->post_imagem : 'nopic.jpg' ?>" class="img-circle">
                                                        </td>
                                                        <td><?= stripslashes($p->post_nome) ?></td>
                                                        <td><?= Helpers\Format::InverterData($p->post_data) ?></td>
                                                        <td><?= Helpers\Validacao::cut(stripslashes($p->post_descricao), 150, '...') ?></td>
                                                        <td>
                                                            <a class="btn btn-sm btn-default" href="comentario.php?id=<?= $p->post_id ?>">
                                                                <i class="fa fa-comments-o"></i>
                                                            </a> 
                                                            <a class="btn btn-sm btn-default" href="post_editar.php?id=<?= $p->post_id ?>">
                                                                <i class="fa fa-edit"></i>
                                                            </a> 
                                                            <a class="btn btn-sm btn-danger excluir" data-url="post_fn.php?acao=remover&AMP;id=<?= $p->post_id?>"  >
                                                                <i class="fa fa-trash"></i>
                                                            </a>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
            <?php require_once './rodape.php'; ?>
            <?php require_once './control_sidebar.php'; ?>
            <div class='control-sidebar-bg'></div>
        </div>
        <!-- jQuery 2.1.4 -->
        <script src="plugins/jQuery/jQuery-2.1.4.min.js"></script>
        <!-- Bootstrap 3.3.2 JS -->
        <script src="bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
        <script src='plugins/sweetalert/dist/sweetalert.min.js'></script>
        <script src='plugins/bootstrap-fileinput/js/fileinput.min.js'></script>
        <!-- DATA TABES SCRIPT -->
        <script src="plugins/datatables/jquery.dataTables.min.js" type="text/javascript"></script>
        <script src="plugins/datatables/dataTables.bootstrap.min.js" type="text/javascript"></script>
        <!-- SlimScroll -->
        <script src="plugins/slimScroll/jquery.slimscroll.min.js" type="text/javascript"></script>
        <!-- FastClick -->
        <script src='plugins/fastclick/fastclick.min.js'></script>
        <script src='plugins/sweetalert/sweetalert.js'></script>
        <!-- AdminLTE App -->
        <script src="dist/js/app.min.js" type="text/javascript"></script>
        <!-- AdminLTE for demo purposes -->
        <script src="dist/js/demo.js" type="text/javascript"></script>
        <!-- page script -->
        <script type="text/javascript">
            $(".posts").addClass('active');
<?php if (isset($_GET['cadastrado'])): ?>
                _alertsuccess("Sucesso!", "Post Cadastrado.");
<?php endif; ?>
<?php if (isset($_GET['atualizado'])): ?>
                _alertsuccess("Sucesso!", "Post Atualizado.");
<?php endif; ?>
<?php if (isset($_GET['removido'])): ?>
                _alertsuccess("Deletado!", "O registro foi removido :(");
<?php endif; ?>
            $(function () {
                $("table").dataTable();
            });
        </script>
    </body>
</html>
