<?php
require_once __DIR__ . '/../vendor/autoload.php';
$sid = new \Model\Session();
$sid->start();
if (!$sid->check()) {
    header('location:' . \Validacao::getBaseAdmin() . 'login.php');
    exit;
}
$usuario = (new Models\Usuario)->show();
?>
<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <title>ADMIN | Galeria de Fotos</title>
        <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
        <link href="bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
        <link href="plugins/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
        <link href="plugins/ionicons/css/ionicons.min.css" rel="stylesheet" type="text/css" />
        <link href="plugins/input-text/style.min.css" rel="stylesheet" type="text/css" />
        <link href="plugins/datatables/dataTables.bootstrap.css" rel="stylesheet" type="text/css" />
        <link href="plugins/bootstrap-fileinput/css/fileinput.min.css" rel="stylesheet" type="text/css" />
        <link href="plugins/sweetalert/dist/sweetalert.css" rel="stylesheet" type="text/css" />
        <link href="dist/css/AdminLTE.min.css" rel="stylesheet" type="text/css" />
        <link href="dist/css/skins/_all-skins.min.css" rel="stylesheet" type="text/css" />
        <link href="dist/css/skins/ui.css" rel="stylesheet" type="text/css" />
        <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
            <script src="plugins/jQuery/html5shiv.min.js"></script>
            <script src="plugins/jQuery/respond.min.js"></script>
        <![endif]-->
    </head>
    <body class="skin-blue sidebar-mini">
        <div class="wrapper">
            <header class="main-header">
                <?php require_once './topo.php'; ?>
            </header>
            <aside class="main-sidebar">
                <?php require_once './menu.php'; ?>
            </aside>
            <div class="content-wrapper">
                <section class="content-header">
                    <h1> Gerênciar  Usuário(s)</h1>
                    <ol class="breadcrumb">
                        <li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
                        <li class="active">Usuário(s)</li>
                    </ol>
                </section>
                <section class="content">
                    <div class="row">
                        <div class="col-xs-12">
                            <div class="box box-primary">
                                <div class="box-header">
                                    <button data-toggle="modal" data-target="#modal-bootstrap-timepicker" class="btn btn-sm btn-primary">
                                        <i class="fa fa-plus"></i>
                                        Adicionar novo
                                    </button>
                                    <p></p>
                                    <h3 class="box-title">Usuário(s) Cadastrado(s)</h3>
                                </div>
                                <div class="box-body">
                                    <table class="table table-bordered table-hover">
                                        <thead>
                                            <tr>
                                                <th>Nome</th>
                                                <th>E-email</th>
                                                <th width="85">Ações</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php if (isset($usuario[0])): ?>
                                                <?php foreach ($usuario as $users): ?>
                                                    <tr>
                                                        <td><?= $users->usuario_nome ?></td>
                                                        <td><?= $users->usuario_email ?></td>
                                                        <td>
                                                            <a class="btn btn-sm btn-default atualizar" data-update="<?= $users->usuario_id ?>">
                                                                <i class="fa fa-edit"></i>
                                                            </a> 
                                                            <a class="btn btn-sm btn-danger excluir" <?php echo $users->usuario_id == 1 ? "disabled='disabled'" : "data-url='usuario_fn.php?acao=remover&AMP;usuario_id=$users->usuario_id'" ?> >
                                                                <i class="fa fa-trash"></i>
                                                            </a>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
            <!--=======================================================MODAL INCLUIR ====================================================-->
            <div class="modal fade " id="modal-bootstrap-timepicker" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-topfull">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="icons-office-52"></i></button>
                            <h4 class="modal-title"><strong>Cadastrar </strong> Usuário</h4>
                        </div>
                        <form enctype="multipart/form-data" method="post" action="usuario_fn.php?acao=incluir">
                            <div class="modal-body" id="hoshi">
                                <span class="input input--hoshi">
                                    <input class="input__field input__field--hoshi" type="text" name="usuario_nome" required />
                                    <label class="input__label input__label--hoshi input__label--hoshi-color-1" for="usuario_nome">
                                        <span class="input__label-content input__label-content--hoshi">Nome</span>
                                    </label>
                                </span>

                                <span class="input input--hoshi">
                                    <input class="input__field input__field--hoshi" type="email"  name="usuario_email" />
                                    <label class="input__label input__label--hoshi input__label--hoshi-color-1" for="usuario_email">
                                        <span class="input__label-content input__label-content--hoshi">Email</span>
                                    </label>
                                </span>
                                <span class="input input--hoshi">
                                    <input class="input__field input__field--hoshi"  type="password"  name="usuario_senha" />
                                    <label class="input__label input__label--hoshi input__label--hoshi-color-1" for="usuario_senha">
                                        <span class="input__label-content input__label-content--hoshi">Senha</span>
                                    </label>
                                </span>
                            </div>
                            <div class="modal-footer bg-gray-light">
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-default btn-embossed" data-dismiss="modal">Cancelar</button>
                                    <button type="submit" class="btn btn-primary btn-embossed">Cadastrar</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <!--=======================================================MODAL INCLUIR ====================================================-->
            <!--=======================================================MODAL ATUALIZAR ====================================================-->
            <div class="modal fade " id="modal-atualizar" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog modal-topfull">
                    <div class="modal-content">
                        <div class="modal-header">
                            <span class="input">
                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="icons-office-52"></i></button>
                                <h4 class="modal-title"><strong>Editar</strong> Usuário</h4>
                            </span>
                        </div>
                        <form enctype="multipart/form-data" method="post" autocomplete="off" action="usuario_fn.php?acao=atualizar">
                            <div class="modal-body" id="hoshi">
                                <span class="input input--hoshi">
                                    <input class="input__field input__field--hoshi" type="text" id="usuario_nome"   name="usuario_nome" required />
                                    <label class="input__label input__label--hoshi input__label--hoshi-color-1" for="usuario_nome">
                                        <span class="input__label-content input__label-content--hoshi">Nome</span>
                                    </label>
                                </span>
                                <span class="input input--hoshi">
                                    <input class="input__field input__field--hoshi" type="email" id="usuario_email"   name="usuario_email" />
                                    <label class="input__label input__label--hoshi input__label--hoshi-color-1" for="usuario_email">
                                        <span class="input__label-content input__label-content--hoshi">Email</span>
                                    </label>
                                </span>
                                <span class="input input--hoshi">
                                    <input class="input__field input__field--hoshi" type="password" autocomplete="off" name="usuario_senha" required />
                                    <label class="input__label input__label--hoshi input__label--hoshi-color-1" for="usuario_senha">
                                        <span class="input__label-content input__label-content--hoshi">Senha</span>
                                        <input type="hidden" id="usuario_id" name="usuario_id" />
                                    </label>
                                </span>
                            </div>
                            <div class="modal-footer bg-gray-light">
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-default btn-embossed" data-dismiss="modal">Cancelar</button>
                                    <button type="submit" class="btn btn-primary btn-embossed">Atualizar</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <!--=======================================================MODAL ATUALIZAR ====================================================-->
            <?php require_once './rodape.php'; ?>
            <div class='control-sidebar-bg'></div>
        </div>
        <script src="plugins/jQuery/jQuery-2.1.4.min.js"></script>
        <script src="bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
        <script src='plugins/sweetalert/dist/sweetalert.min.js'></script>
        <script src='plugins/bootstrap-fileinput/js/fileinput.min.js'></script>
        <script src="plugins/datatables/jquery.dataTables.min.js" type="text/javascript"></script>
        <script src="plugins/datatables/dataTables.bootstrap.min.js" type="text/javascript"></script>
        <script src="plugins/slimScroll/jquery.slimscroll.min.js" type="text/javascript"></script>
        <script src='plugins/fastclick/fastclick.min.js'></script>
        <script src='plugins/sweetalert/sweetalert.js'></script>
        <script src="dist/js/app.min.js" type="text/javascript"></script>
        <script src="dist/js/demo.js" type="text/javascript"></script>
        <script type="text/javascript">
            $(".usuario").addClass('active');
<?php if (isset($_GET['adicionado'])): ?>
                _alertsuccess("Sucesso!", "Usuario Cadastrado.");
<?php endif; ?>
<?php if (isset($_GET['atualizado'])): ?>
                _alertsuccess("Sucesso!", "Usuario Atualizado.");
<?php endif; ?>
<?php if (isset($_GET['removido'])): ?>
                _alertsuccess("Deletado!", "O registro foi removido :(");
<?php endif; ?>
            $('.atualizar').on('click', function () {
                var id = $(this).attr('data-update');
                $('#usuario_id').val(id);
                var url = "usuario_fn.php?acao=Json";
                $.getJSON(url, {usuario_id: id}, function (data) {
                    //console.log(data);
                    $('#modal-atualizar  #usuario_id').val(data.usuario_id);
                    $('#modal-atualizar  #usuario_nome').val(data.usuario_nome);
                    $('#modal-atualizar  #usuario_login').val(data.usuario_login);
                    $('#modal-atualizar  #usuario_email').val(data.usuario_email);
                });
                $('#modal-atualizar').modal('show');
            });
            $(function () {
                $("table").dataTable();
            });
        </script>
    </body>
</html>
