<?php

require_once __DIR__ . '/../frota/vendor/autoload.php';
$sid = new \Model\Session();
$sid->start();
if (!$sid->check()) {
    header('location:' . \Validacao::getBaseAdmin() . 'login.php');
    exit;
}

function incluir() {
    $data = filter_input_array(INPUT_POST, FILTER_DEFAULT);
    $arquivo = explode('.', $_FILES["viagem_pdf"]['name']);
    $nome_final = str_slug($arquivo[0]) . time() . '.pdf';
    move_uploaded_file($_FILES["viagem_pdf"]['tmp_name'], "../uploads/viagem/$nome_final");
    $pdf = ['viagem_pdf' => $nome_final];
    $array = array_merge($data, $pdf);
    $id = \Models\Viagem::insertGetId($array);
    Filter::redirect("viagem_editar.php?id=$id");
}

function atualizar() {
    $data = filter_input_array(INPUT_POST, FILTER_DEFAULT);
    $atualizar = \Models\Viagem::find($data['viagem_id']);
    if ($_FILES["viagem_pdf"]['name'] != '') {
        if (file_exists('../uploads/viagem/' . $atualizar->viagem_pdf)) {
            @unlink('../uploads/viagem/' . $atualizar->viagem_pdf);
        }
        $arquivo = explode('.', $_FILES["viagem_pdf"]['name']);
        $nome_final = str_slug($arquivo[0]) . time() . '.pdf';
        move_uploaded_file($_FILES["viagem_pdf"]['tmp_name'], "../uploads/viagem/$nome_final");
        $data = ['viagem_pdf' => $nome_final] + $data;
    } else {
        unset($data["viagem_pdf"]);
    }
    $atualizar->update($data);
    Filter::redirect("viagem.php?atualizado");
}

function remover() {
    $data = filter_input_array(INPUT_GET, FILTER_DEFAULT);
    $remover = \Models\Viagem::find($data['viagem_id']);
    $foto = (new Models\Fotov)->FotoByViagem($data['viagem_id']);
    foreach ($foto as $item) {
        if (file_exists('../uploads/viagem/' . $item->fotov_url)) {
            @unlink('../uploads/viagem/' . $item->fotov_url);
        }
        $item->delete();
    }
    if (file_exists('../uploads/viagem/' . $remover->viagem_pdf)) {
        @unlink('../uploads/viagem/' . $remover->viagem_pdf);
    }
    $remover->delete();
    Filter::redirect("viagem.php?removido");
}

if (isset($_REQUEST['acao']) && !empty($_REQUEST['acao'])) {
    $acao = $_REQUEST['acao'];
    if (function_exists($acao)) {
        $acao();
    }
}

