<?php
require_once __DIR__ . '/../vendor/autoload.php';
$sid = new \Model\Session();
$sid->start();
if (!$sid->check()) {
    header('location:' . \Validacao::getBaseAdmin() . 'login.php');
    exit;
}
$videos = (new \Models\Video)->show();
?>
<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <title>ADMIN | Galeria de Fotos</title>
        <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
        <link href="bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
        <link href="plugins/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
        <link href="plugins/ionicons/css/ionicons.min.css" rel="stylesheet" type="text/css" />
        <link href="plugins/input-text/style.min.css" rel="stylesheet" type="text/css" />
        <link href="plugins/datatables/dataTables.bootstrap.css" rel="stylesheet" type="text/css" />
        <link href="plugins/bootstrap-fileinput/css/fileinput.min.css" rel="stylesheet" type="text/css" />
        <link href="plugins/sweetalert/dist/sweetalert.css" rel="stylesheet" type="text/css" />
        <link href="dist/css/AdminLTE.min.css" rel="stylesheet" type="text/css" />
        <link href="dist/css/skins/_all-skins.min.css" rel="stylesheet" type="text/css" />
        <link href="dist/css/skins/ui.css" rel="stylesheet" type="text/css" />
        <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
            <script src="plugins/jQuery/html5shiv.min.js"></script>
            <script src="plugins/jQuery/respond.min.js"></script>
        <![endif]-->
    </head>
    <body class="skin-blue sidebar-mini">
        <div class="wrapper">

            <header class="main-header">
                <?php require_once './topo.php'; ?>
            </header>
            <aside class="main-sidebar">
                <?php require_once './menu.php'; ?>
            </aside>
            <div class="content-wrapper">
                <section class="content-header">
                    <h1>Videos</h1>
                    <ol class="breadcrumb">
                        <li><a href="index.php"><i class="fa fa-dashboard"></i> Home</a></li>
                        <li class="active">Videos</li>
                    </ol>
                </section>

                <section class="content">
                    <div class="row">
                        <div class="col-xs-12">
                            <div class="box box-primary">
                                <div class="box-header">
                                    <button data-toggle="modal" data-target="#modal-bootstrap-timepicker" class="btn btn-sm btn-primary">
                                        <i class="fa fa-plus"></i>
                                        Adicionar novo
                                    </button>
                                    <p></p>
                                </div>
                                <div class="box-body">
                                    <?php if (isset($videos[0])): ?>
                                        <?php foreach ($videos as $v): ?>
                                            <div class="col-md-3 thumbnail">
                                                <span class="video_title"><?= Validacao::cut(stripslashes($v->video_nome), 60, '...') ?><span>
                                                        <embed  src=" <?= $v->video_thumb ?>"  allowscriptaccess="always" allowfullscreen="true" width="400" height="250">                                     
                                                        <div class="text-center">
                                                            <a href="javascript:void(0)" class="btn btn-primary atualizar" data-update="<?= $v->video_id ?>"><i class="fa fa-edit"></i></a>
                                                            <a href="javascript:void(0)" class="btn btn-danger excluir" data-url="video_fn.php?acao=remover&AMP;video_id=<?= $v->video_id ?>">
                                                                <i class="fa fa-trash"></i>
                                                            </a>
                                                        </div>
                                                        </div>
                                                    <?php endforeach; ?>
                                                <?php endif; ?>
                                                </div>
                                                </div>
                                                </div>
                                                </div>
                                                </section>
                                                <!--=======================================================MODAL INCLUIR ====================================================-->
                                                <div class="modal fade " id="modal-bootstrap-timepicker" tabindex="-1" role="dialog" aria-hidden="true">
                                                    <div class="modal-dialog  modal-primary">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="icons-office-52"></i></button>
                                                                <h4 class="modal-title text-center"><strong>Cadastrar </strong> Video</h4>
                                                            </div>
                                                            <form enctype="multipart/form-data" method="post" action="video_fn.php?acao=incluir">
                                                                <div class="modal-body" id="hoshi" style="background: #FFF !important;">
                                                                    <span class="input input--hoshi">
                                                                        <input class="input__field input__field--hoshi" type="text" name="video_nome" required />
                                                                        <label class="input__label input__label--hoshi input__label--hoshi-color-1" for="video_nome">
                                                                            <span class="input__label-content input__label-content--hoshi">Título</span>
                                                                        </label>
                                                                    </span>
                                                                    <span class="input input--hoshi">
                                                                        <input class="input__field input__field--hoshi" type="text" name="video_url" required />
                                                                        <label class="input__label input__label--hoshi input__label--hoshi-color-1" for="video_url">
                                                                            <span class="input__label-content input__label-content--hoshi">URL</span>
                                                                        </label>
                                                                    </span>
                                                                </div>
                                                                <div class="modal-footer bg-gray-light">
                                                                    <div class="modal-footer">
                                                                        <button type="button" class="btn btn-default btn-embossed" data-dismiss="modal">Cancelar</button>
                                                                        <button type="submit" class="btn btn-primary btn-embossed">Cadastrar</button>
                                                                    </div>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!--=======================================================MODAL INCLUIR ====================================================-->
                                                <!--=======================================================MODAL ATUALIZAR ====================================================-->
                                                <div class="modal fade " id="modal-atualizar" tabindex="-1" role="dialog" aria-hidden="true">
                                                    <div class="modal-dialog modal-warning">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <span class="input">
                                                                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="icons-office-52"></i></button>
                                                                    <h4 class="modal-title text-center"><strong>Editar</strong> Video</h4>
                                                                </span>
                                                            </div>
                                                            <form enctype="multipart/form-data" method="post" action="video_fn.php?acao=atualizar">
                                                                <div class="modal-body" id="hoshi"  style="background: #FFF !important;">
                                                                    <span class="input input--hoshi">
                                                                        <input class="input__field input__field--hoshi" type="text" id="video_nome"   name="video_nome" required />
                                                                        <label class="input__label input__label--hoshi input__label--hoshi-color-1" for="video_nome">
                                                                            <span class="input__label-content input__label-content--hoshi">Título</span>
                                                                        </label>
                                                                    </span>
                                                                    <span class="input input--hoshi">
                                                                        <input class="input__field input__field--hoshi" type="text" id="video_url"   name="video_url" required />
                                                                        <label class="input__label input__label--hoshi input__label--hoshi-color-1" for="video_url">
                                                                            <span class="input__label-content input__label-content--hoshi">URL</span>
                                                                            <input type="hidden" id="video_id" name="video_id" />
                                                                        </label>
                                                                    </span>
                                                                </div>
                                                                <div class="modal-footer bg-gray-light">
                                                                    <div class="modal-footer">
                                                                        <button type="button" class="btn btn-default btn-embossed" data-dismiss="modal">Cancelar</button>
                                                                        <button type="submit" class="btn btn-primary btn-embossed">Atualizar</button>
                                                                    </div>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!--=======================================================MODAL ATUALIZAR ====================================================-->


                                                </div>
                                                <?php require_once './rodape.php'; ?>
                                                <div class='control-sidebar-bg'></div>
                                                </div>
                                                <script src="plugins/jQuery/jQuery-2.1.4.min.js"></script>
                                                <script src="bootstrap/js/bootstrap.min.js" type="text/javascript"></script>
                                                <script src='plugins/sweetalert/dist/sweetalert.min.js'></script>
                                                <script src='plugins/bootstrap-fileinput/js/fileinput.min.js'></script>
                                                <script src="plugins/datatables/jquery.dataTables.min.js" type="text/javascript"></script>
                                                <script src="plugins/datatables/dataTables.bootstrap.min.js" type="text/javascript"></script>
                                                <script src="plugins/slimScroll/jquery.slimscroll.min.js" type="text/javascript"></script>
                                                <script src='plugins/fastclick/fastclick.min.js'></script>
                                                <script src='plugins/sweetalert/sweetalert.js'></script>
                                                <script src="dist/js/app.min.js" type="text/javascript"></script>
                                                <script src="dist/js/demo.js" type="text/javascript"></script>
                                                <script type="text/javascript">
                                                    $("#video").addClass('active');
<?php if (isset($_GET['adicionado'])): ?>
                                                        _alertsuccess("Sucesso!", "Usuario Cadastrado.");
<?php endif; ?>
<?php if (isset($_GET['atualizado'])): ?>
                                                        _alertsuccess("Sucesso!", "Usuario Atualizado.");
<?php endif; ?>
<?php if (isset($_GET['removido'])): ?>
                                                        _alertsuccess("Deletado!", "O registro foi removido :(");
<?php endif; ?>
                                                    $('.atualizar').on('click', function () {
                                                        var id = $(this).attr('data-update');
                                                        $('#video_id').val(id);
                                                        var url = "video_fn.php?acao=Json";
                                                        $.getJSON(url, {video_id: id}, function (data) {
                                                            //console.log(data);
                                                            $('#modal-atualizar  #video_id').val(data.video_id);
                                                            $('#modal-atualizar  #video_nome').val(data.video_nome);
                                                            $('#modal-atualizar  #video_url').val(data.video_url);
                                                        });
                                                        $('#modal-atualizar').modal('show');
                                                    });
                                                    $(function () {
                                                        $("table").dataTable();
                                                    });
                                                </script>
                                                </body>
                                                </html>
