<?php
/**
 * @author Marcelo Rocha <catracacelo@gmail.com> <marcelo@planetascript.com>
 * <website www.planetascript.com>
 * Classe Usuario
 */
class Format {

    static function agora() {
        return date('d/m/Y H:i:s');
    }

    static function agora2() {
        setlocale(LC_ALL, "pt_BR", "pt_BR.iso-8859-1", "pt_BR.utf-8", "portuguese");
        date_default_timezone_set('America/Sao_Paulo');
        $data_completa = strftime("%A, %d de %B de %Y");
        echo $data_completa;
    }

    static function percent($number) {
        return $number * 100 . '%';
    }

    static function inteiro($number) {
        $numero = number_format($number);
        return $numero;
    }

    static function moeda($valor, $moeda = 'brl', $mostrar_zero = false) {
        return $valor ? number_format($valor, 2, ',', '.') : ($mostrar_zero ? '0,00' : '');
    }

    static function moeda_bd($valor) {
        $replace = array('.', '-', '');
        $total = str_replace($replace, "", $valor);
        return $total;
    }

    static function dif_horario($horario1, $horario2) {
        $h1 = strtotime("$horario1");
        $h2 = strtotime("$horario2");
        $h3 = $h2 - $h1;

        $anos = ($h3 / (60 * 60 * 24 * 365));
        $dias = ($h3 / (60 * 60 * 24)) % 365;
        $horas = ($h3 / (60 * 60)) % 24;
        echo $minutos = ($h3 / 60) % 60;
    }

    static function LongitudeLatitude($endereço) {
        $Address = urlencode($endereço);
        $request_url = "http://maps.googleapis.com/maps/api/geocode/xml?address=" . $Address . "&sensor=true";
        $xml = simplexml_load_file($request_url) or die("url not loading");
        $status = $xml->status;
        if ($status == "OK") {
            $Lat = $xml->result->geometry->location->lat;
            $Lon = $xml->result->geometry->location->lng;
            return $LatLng = "$Lat,$Lon";
        }
    }

    static function InverterData($campo) {
        if (substr($campo, 2, 1) == '/') {
            $campo = substr($campo, 6, 4) . '-' . substr($campo, 3, 2) . '-' . substr($campo, 0, 2); //2012-10-10
        } else {
            $campo = substr($campo, 8, 2) . '/' . substr($campo, 5, 2) . '/' . substr($campo, 0, 4); //10/10/2012
        }

        return($campo);
    }

    static function video_thumb($url) {
        $url_imagem = parse_url($url);
        if ($url_imagem['host'] == 'www.youtube.com' || $url_imagem['host'] == 'youtube.com') {
            $array = explode("&", $url_imagem['query']);
            return "http://img.youtube.com/vi/" . substr($array[0], 2) . "/0.jpg";
        } else if ($url_imagem['host'] == 'www.vimeo.com' || $url_imagem['host'] == 'vimeo.com') {
            $hash = unserialize(file_get_contents("http://vimeo.com/api/v2/video/" . substr($url_imagem['path'], 1) . ".php"));
            return $hash[0]["thumbnail_large"];
        }
    }

    /**
     * welcome this simple script which composes the object tag from the video URL
     * for youtube, Google video, Metacafe ,vimeo and mashahd
     * it's easy to use it by just include this script on your php page
     * and write this simple line <br/>
     * <code>
     *  include_once 'tag.php';
     *  qtm_tag_video(array('url'=>'http://www.youtube.com/watch?v=gtKMT6PnmCc','width'=>600,'height'=>400),"");
     * </code>
     * or you can set it to the default size <br/>
     *
     * <code>
     *  include_once 'tag.php';
     *  qtm_tag_video(array('url'=>'http://www.youtube.com/watch?v=gtKMT6PnmCc'),"");
     * </code>

     * @param <type> $attrs
     * @param <type> $body
     * @param <type> $options
     * @return <String>
     */
    static function UrlVideo($attrs, $options) {
        $url = trim($attrs['url']);
        $type = &$attrs['type'];

        $width = $attrs['width'];
        if ($width == null)
            $width = $options['video_width'];
        $height = $attrs['height'];
        if ($width == null)
            $width = $options['video_height'];

        $buffer = '<div style="clear: both"></div>';

        // Oldish...
        if ($type != '') {
            if ($type == 'youtube') {
                if ($width == '')
                    $width = 425;
                if ($height == '')
                    $height = 350 / 425 * $width;
                $id = &$attrs['id'];
                $url = 'http://www.youtube.com/v/' . $id;
                $buffer .= '<object width="' . $width . '" height="' . $height . '"><param name="movie" value="' .
                        $url . '"></param><param name="wmode" value="transparent"></param><embed src="' . $url .
                        '" type="application/x-shockwave-flash" wmode="transparent" width="' . $width . '" height="' .
                        $height . '"></embed></object>';
            }
            else if ($type == 'google') {
                if ($width == '')
                    $width = 400;
                if ($height == '')
                    $height = 326 / 400 * $width;
                $url = 'http://video.google.com/googleplayer.swf?docId=' . $id;
                $buffer .= '<embed style="width:' . $width . 'px; height:' . $height .
                        'px;" id="VideoPlayback" type="application/x-shockwave-flash" src="' .
                        $url . '" flashvars=""></embed>';
            }
        }
        else {
            if (strpos($url, 'metacafe.com') !== false) {
                if ($width == '')
                    $width = 400;
                if ($height == '')
                    $height = 345 / 400 * $width;

                $x = strpos($url, '/watch/');
                $url = 'http://www.metacafe.com/fplayer/' . substr($url, $x + 7, -1) . '.swf';

                $buffer .= '<embed src="' . $url . '" width="' . $width . '" height="' . $height .
                        '" wmode="transparent" pluginspage="http://www.macromedia.com/go/getflashplayer" ' .
                        'type="application/x-shockwave-flash"></embed>';
            }
            else if (strpos($url, 'youtube.com') !== false) {
                if ($width == '')
                    $width = 425;
                if ($height == '')
                    $height = 350 / 425 * $width;

                $x = strpos($url, 'watch?v=');
                $url = 'http://www.youtube.com/v/' . substr($url, $x + 8);

                $buffer .= '<object width="' . $width . '" height="' . $height . '"><param name="movie" value="' .
                        $url . '"></param><param name="wmode" value="transparent"></param><embed src="' . $url .
                        '" type="application/x-shockwave-flash" wmode="transparent" width="' . $width . '" height="' .
                        $height . '"></embed></object>';
            }
            else if (strpos($url, 'google.com') !== false) {
                if ($width == '')
                    $width = 400;
                if ($height == '')
                    $height = 326 / 400 * $width;

                $x = strpos($url, 'docid=');
                $url = 'http://video.google.com/googleplayer.swf?docId=' . substr($url, $x + 6);

                $buffer .= '<embed style="width:' . $width . 'px; height:' . $height .
                        'px;" id="VideoPlayback" type="application/x-shockwave-flash" src="' .
                        $url . '" flashvars=""></embed>';
            }
            else if (strpos($url, 'mashahd.net') !== false) {
                if ($width == '')
                    $width = 425;
                if ($height == '')
                    $height = 350 / 425 * $width;

                $x = strpos($url, 'viewkey=');
                $url = 'http://www.mashahd.net/player/vPlayer.swf?f=http://www.mashahd.net/player/vConfig.php?vkey=' . substr($url, $x + 8);

                $buffer .= '<object width="' . $width . '" height="' . $height . '"><param name="movie" value="' .
                        $url . '"></param><param name="wmode" value="transparent"></param><embed src="' . $url .
                        '" type="application/x-shockwave-flash" wmode="transparent" width="' . $width . '" height="' .
                        $height . '" name="main" id="main" allowfullscreen="true" ></embed></object>';
            }
            else if (strpos($url, 'vimeo.com') !== false) {
                if ($width == '')
                    $width = 425;
                if ($height == '')
                    $height = 350 / 425 * $width;

                $x = strpos($url, 'vimeo.com/');
                $url = 'http://vimeo.com/moogaloop.swf?clip_id=' . substr($url, $x + 10) . '&amp;server=vimeo.com&amp;show_title=1&amp;show_byline=1&amp;show_portrait=0&amp;color=&amp;fullscreen=1';

                $buffer .= '<object width="' . $width . '" height="' . $height . '"><param name="movie" value="' .
                        $url . '"></param><param name="wmode" value="transparent"></param><embed src="' . $url .
                        '" type="application/x-shockwave-flash" wmode="transparent" width="' . $width . '" height="' .
                        $height . '" name="main" id="main" allowfullscreen="true" ></embed></object>';
            }
        }

        return $buffer . '<div style="clear: both"></div>';
    }
    
    public static function Extension($img) {
        $type = exif_imagetype($img);
        $extension = image_type_to_extension($type);
        $filename = time() . $extension;
        return $filename;
    }
}
